/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.event.AncestorEvent;
import com.sun.java.swing.event.AncestorListener;
import com.sun.java.swing.event.EventListenerList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

class AncestorNotifier
implements ComponentListener,
PropertyChangeListener,
Serializable {
    Component firstInvisibleAncestor;
    EventListenerList listenerList = new EventListenerList();
    JComponent root;
    static /* synthetic */ Class class$com$sun$java$swing$event$AncestorListener;

    AncestorNotifier(JComponent jComponent) {
        this.root = jComponent;
        this.addListeners(jComponent, true);
    }

    void addAncestorListener(AncestorListener ancestorListener) {
        this.listenerList.add(class$com$sun$java$swing$event$AncestorListener != null ? class$com$sun$java$swing$event$AncestorListener : (class$com$sun$java$swing$event$AncestorListener = AncestorNotifier.class$("com.sun.java.swing.event.AncestorListener")), ancestorListener);
    }

    void removeAncestorListener(AncestorListener ancestorListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$AncestorListener != null ? class$com$sun$java$swing$event$AncestorListener : (class$com$sun$java$swing$event$AncestorListener = AncestorNotifier.class$("com.sun.java.swing.event.AncestorListener")), ancestorListener);
    }

    protected void fireAncestorAdded(JComponent jComponent, int n, Container container, Container container2) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$com$sun$java$swing$event$AncestorListener != null ? class$com$sun$java$swing$event$AncestorListener : AncestorNotifier.class$("com.sun.java.swing.event.AncestorListener"))) {
                AncestorEvent ancestorEvent = new AncestorEvent(jComponent, n, container, container2);
                ((AncestorListener)objectArray[n2 + 1]).ancestorAdded(ancestorEvent);
            }
            n2 -= 2;
        }
    }

    protected void fireAncestorRemoved(JComponent jComponent, int n, Container container, Container container2) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$com$sun$java$swing$event$AncestorListener != null ? class$com$sun$java$swing$event$AncestorListener : AncestorNotifier.class$("com.sun.java.swing.event.AncestorListener"))) {
                AncestorEvent ancestorEvent = new AncestorEvent(jComponent, n, container, container2);
                ((AncestorListener)objectArray[n2 + 1]).ancestorRemoved(ancestorEvent);
            }
            n2 -= 2;
        }
    }

    protected void fireAncestorMoved(JComponent jComponent, int n, Container container, Container container2) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$com$sun$java$swing$event$AncestorListener != null ? class$com$sun$java$swing$event$AncestorListener : AncestorNotifier.class$("com.sun.java.swing.event.AncestorListener"))) {
                AncestorEvent ancestorEvent = new AncestorEvent(jComponent, n, container, container2);
                ((AncestorListener)objectArray[n2 + 1]).ancestorMoved(ancestorEvent);
            }
            n2 -= 2;
        }
    }

    void removeAllListeners() {
        this.removeListeners(this.root);
    }

    void addListeners(Component component, boolean bl) {
        this.firstInvisibleAncestor = null;
        Component component2 = component;
        while (this.firstInvisibleAncestor == null) {
            if (bl || component2 != component) {
                component2.addComponentListener(this);
                if (component2 instanceof JComponent) {
                    JComponent jComponent = (JComponent)component2;
                    jComponent.addPropertyChangeListener(this);
                }
            }
            if (!component2.isVisible() || component2.getParent() == null) {
                this.firstInvisibleAncestor = component2;
            }
            component2 = component2.getParent();
        }
        if (this.firstInvisibleAncestor instanceof Window) {
            this.firstInvisibleAncestor = null;
        }
    }

    void removeListeners(Component component) {
        Component component2 = component;
        while (component2 != this.firstInvisibleAncestor) {
            component2.removeComponentListener(this);
            if (component2 instanceof JComponent) {
                JComponent jComponent = (JComponent)component2;
                jComponent.removePropertyChangeListener(this);
            }
            component2 = component2.getParent();
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.fireAncestorMoved(this.root, 3, (Container)component, component.getParent());
    }

    public void componentShown(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        if (component == this.firstInvisibleAncestor) {
            this.addListeners(component, false);
            if (this.firstInvisibleAncestor == null) {
                this.fireAncestorAdded(this.root, 1, (Container)component, component.getParent());
            }
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        boolean bl = this.firstInvisibleAncestor == null;
        this.removeListeners(component.getParent());
        this.firstInvisibleAncestor = component;
        if (bl) {
            this.fireAncestorRemoved(this.root, 2, (Container)component, component.getParent());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("parent") || string.equals("ancestor")) {
            JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
            if (propertyChangeEvent.getNewValue() != null) {
                if (jComponent == this.firstInvisibleAncestor) {
                    this.addListeners(jComponent, false);
                    if (this.firstInvisibleAncestor == null) {
                        this.fireAncestorAdded(this.root, 1, jComponent, jComponent.getParent());
                        return;
                    }
                }
            } else {
                boolean bl = this.firstInvisibleAncestor == null;
                Container container = (Container)propertyChangeEvent.getOldValue();
                this.removeListeners(container);
                this.firstInvisibleAncestor = jComponent;
                if (bl) {
                    this.fireAncestorRemoved(this.root, 2, jComponent, container);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

